<?php
require_once '../includes/db.php';
require_once '../includes/config.php';
require_once '../includes/admin_auth.php';
require_once '../includes/functions.php';

$orders = $pdo->query("
    SELECT o.*, 
           u.name AS customer, 
           u.phone
    FROM orders o 
    JOIN user_tbl u ON o.user_id = u.user_id 
    ORDER BY o.created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Orders - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Data Orders</h2>
    <table>
        <tr>
            <th>ID</th>
            <th>Customer</th>
            <th>Total</th>
            <th>Status</th>
            <th>Aksi</th>
        </tr>
        <?php foreach ($orders as $o): ?>
        <tr>
            <td>#<?= $o['order_id'] ?></td>
            <td><?= $o['customer'] ?></td>
            <td><?= rupiah($o['total_price']) ?></td>
            <td><?= ucfirst($o['status']) ?></td>
            <td>
                <!-- Selalu ada tombol detail -->
                <a href="order_detail.php?id=<?= $o['order_id'] ?>" class="btn btn-primary">Detail</a>

                <!-- Jika order paid, munculkan kirim produk -->
                <?php if (strtolower($o['status']) === 'paid'): ?>
                    <a href="send_digital.php?id=<?= $o['order_id'] ?>" class="btn btn-success">Kirim Digital</a>
                    <a href="send_shipment.php?id=<?= $o['order_id'] ?>" class="btn btn-success">Kirim Fisik</a>
                <?php endif; ?>

                <!-- Tombol WA (selalu muncul) -->
                <?php
                $waMessage = getWhatsAppMessageByStatus($o['status'], $o['customer'], $o['order_id']);
                $waLink = generateWhatsAppLink($o['phone'] ?? '', $waMessage);
                ?>
                <a href="<?= $waLink ?>" target="_blank" class="btn btn-success">WA</a>

                <!-- Download Semua Dokumen -->
                <a href="pdf_bundle.php?id=<?= $o['order_id'] ?>" target="_blank" class="btn btn-dark" title="Download Semua Dokumen">All Docs</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
