<?php
require_once '../includes/db.php';
require_once '../includes/admin_auth.php';
require_once '../includes/functions.php';

$msg = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    setSetting('site_name', $_POST['site_name'], $pdo);
    setSetting('site_email', $_POST['site_email'], $pdo);
    setSetting('site_address', $_POST['site_address'], $pdo);
    setSetting('bank_info', $_POST['bank_info'], $pdo);
    setSetting('qris_info', $_POST['qris_info'], $pdo);
    setSetting('aff_level1_percent', $_POST['aff_level1_percent'], $pdo);
    setSetting('aff_level2_percent', $_POST['aff_level2_percent'], $pdo);
    setSetting('wa_admin_phone', $_POST['wa_admin_phone'], $pdo);
    setSetting('wa_pending', $_POST['wa_pending'], $pdo);
    setSetting('wa_paid', $_POST['wa_paid'], $pdo);
    setSetting('wa_shipped', $_POST['wa_shipped'], $pdo);
    setSetting('wa_delivered', $_POST['wa_delivered'], $pdo);
    setSetting('wa_cancelled', $_POST['wa_cancelled'], $pdo);

    // Upload logo jika ada
    if (!empty($_FILES['site_logo']['name'])) {
        $fileName = time() . "_" . basename($_FILES['site_logo']['name']);
        move_uploaded_file($_FILES['site_logo']['tmp_name'], "../assets/img/" . $fileName);
        setSetting('site_logo', $fileName, $pdo);
    }

    $msg = "Pengaturan berhasil disimpan!";
}

$settings = [
    'site_name' => getSetting('site_name', $pdo),
    'site_email' => getSetting('site_email', $pdo),
    'site_address' => getSetting('site_address', $pdo),
    'bank_info' => getSetting('bank_info', $pdo),
    'qris_info' => getSetting('qris_info', $pdo),
    'aff_level1_percent' => getSetting('aff_level1_percent', $pdo),
    'aff_level2_percent' => getSetting('aff_level2_percent', $pdo),
    'wa_admin_phone' => getSetting('wa_admin_phone', $pdo),
    'wa_pending' => getSetting('wa_pending', $pdo),
    'wa_paid' => getSetting('wa_paid', $pdo),
    'wa_shipped' => getSetting('wa_shipped', $pdo),
    'wa_delivered' => getSetting('wa_delivered', $pdo),
    'wa_cancelled' => getSetting('wa_cancelled', $pdo),
    'site_logo' => getSetting('site_logo', $pdo),
];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Pengaturan Toko - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Pengaturan Toko</h2>
    <?php if ($msg): ?><div class="card"><?= $msg ?></div><?php endif; ?>
    <form method="POST" enctype="multipart/form-data">
        <h3>Informasi Toko</h3>
        <label>Nama Toko</label>
        <input type="text" name="site_name" value="<?= $settings['site_name'] ?>" required>

        <label>Email Toko</label>
        <input type="email" name="site_email" value="<?= $settings['site_email'] ?>" required>

        <label>Alamat</label>
        <textarea name="site_address"><?= $settings['site_address'] ?></textarea>

        <label>Logo</label>
        <?php if($settings['site_logo']): ?>
            <p><img src="../assets/img/<?= $settings['site_logo'] ?>" height="50"></p>
        <?php endif; ?>
        <input type="file" name="site_logo">

        <h3>Pembayaran</h3>
        <label>Info Bank</label>
        <textarea name="bank_info"><?= $settings['bank_info'] ?></textarea>

        <label>Link/QRIS</label>
        <textarea name="qris_info"><?= $settings['qris_info'] ?></textarea>

        <h3>Affiliate</h3>
        <label>Komisi Level 1 (%)</label>
        <input type="number" name="aff_level1_percent" value="<?= $settings['aff_level1_percent'] ?>" required>

        <label>Komisi Level 2 (%)</label>
        <input type="number" name="aff_level2_percent" value="<?= $settings['aff_level2_percent'] ?>" required>

        <h3>WhatsApp</h3>
        <label>No WA Admin</label>
        <input type="text" name="wa_admin_phone" value="<?= $settings['wa_admin_phone'] ?>" required>

        <label>Pesan Pending</label>
        <textarea name="wa_pending"><?= $settings['wa_pending'] ?></textarea>

        <label>Pesan Paid</label>
        <textarea name="wa_paid"><?= $settings['wa_paid'] ?></textarea>

        <label>Pesan Shipped</label>
        <textarea name="wa_shipped"><?= $settings['wa_shipped'] ?></textarea>

        <label>Pesan Delivered</label>
        <textarea name="wa_delivered"><?= $settings['wa_delivered'] ?></textarea>

        <label>Pesan Cancelled</label>
        <textarea name="wa_cancelled"><?= $settings['wa_cancelled'] ?></textarea>

        <button class="btn btn-primary" type="submit">Simpan Pengaturan</button>
    </form>
</div>
</body>
</html>
