<?php
require_once __DIR__ . '/../../includes/user_auth.php';
$userId = $_SESSION['user_id'];

// Ambil order + tipe produk
$stmt = $pdo->prepare("
    SELECT o.*, 
           (SELECT GROUP_CONCAT(DISTINCT p.type) 
              FROM order_items oi 
              JOIN products p ON oi.product_id = p.product_id 
             WHERE oi.order_id = o.order_id) AS product_types
    FROM orders o 
    WHERE o.user_id=? 
    ORDER BY o.created_at DESC
");
$stmt->execute([$userId]);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<h2>Histori Order</h2>
<table>
    <tr>
        <th>ID</th><th>Tanggal</th><th>Total</th><th>Status</th><th>Aksi</th>
    </tr>
    <?php foreach ($orders as $o): $types = explode(',', $o['product_types']); ?>
    <tr>
        <td>#<?= $o['order_id'] ?></td>
        <td><?= $o['created_at'] ?></td>
        <td><?= rupiah($o['total_price']) ?></td>
        <td><span class="status-label status-<?= strtolower($o['status']) ?>"><?= ucfirst($o['status']) ?></span></td>
        <td>
            <?php if ($o['status'] === 'pending'): ?>
                <a href="index.php?page=payment_confirm&order_id=<?= $o['order_id'] ?>" class="btn btn-warning">Konfirmasi Bayar</a>
            <?php elseif ($o['status'] === 'paid' && in_array('digital', $types)): ?>
                <a href="index.php?page=digital_confirm&order_id=<?= $o['order_id'] ?>" class="btn btn-success">Konfirmasi Terima</a>
            <?php elseif ($o['status'] === 'shipped'): ?>
                <?php
                $resiData = $pdo->prepare("SELECT courier, tracking_no FROM shipments WHERE order_id=?");
                $resiData->execute([$o['order_id']]);
                foreach ($resiData->fetchAll(PDO::FETCH_ASSOC) as $r):
                ?>
                    <div class="resi-box">Kurir: <?= $r['courier'] ?> | Resi: <?= $r['tracking_no'] ?></div>
                <?php endforeach; ?>
            <?php elseif ($o['status'] === 'delivered'): ?>
                Selesai ✅
            <?php endif; ?>
            <a href="index.php?page=order_detail&id=<?= $o['order_id'] ?>" class="btn btn-primary">Detail</a>
        </td>
    </tr>
    <?php endforeach; ?>
</table>
