<?php
require_once '../includes/db.php';
require_once '../includes/admin_auth.php';

$msg = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = cleanInput($_POST['name']);
    $parent_id = $_POST['parent_id'] ?: null;
    $stmt = $pdo->prepare("INSERT INTO categories (parent_id, name) VALUES (?, ?)");
    $stmt->execute([$parent_id, $name]);
    $msg = "Kategori berhasil ditambahkan";
}

$categories = $pdo->query("SELECT * FROM categories ORDER BY parent_id ASC, category_id ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Categories - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Kelola Kategori</h2>
    <form method="POST">
        <input type="text" name="name" placeholder="Nama Kategori" required>
        <select name="parent_id">
            <option value="">-- Kategori Utama --</option>
            <?php foreach ($categories as $c): ?>
            <option value="<?= $c['category_id'] ?>"><?= $c['name'] ?></option>
            <?php endforeach; ?>
        </select>
        <button class="btn btn-primary" type="submit">Tambah</button>
    </form>
    <p><?= $msg ?></p>
    <hr>
    <ul>
        <?php foreach ($categories as $c): ?>
        <li><?= $c['name'] ?> (parent_id: <?= $c['parent_id'] ?>)</li>
        <?php endforeach; ?>
    </ul>
</div>
</body>
</html>
