<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/pdf_helper.php';

$orderId = (int)$_GET['id'];

$stmt = $pdo->prepare("SELECT o.*, u.name, u.email, u.phone 
    FROM orders o JOIN user_tbl u ON o.user_id=u.user_id WHERE o.order_id=?");
$stmt->execute([$orderId]);
$order = $stmt->fetch();

ob_start();
?>
<h2>KONFIRMASI PEMBAYARAN</h2>
<p>No Order: <?= $order['order_id'] ?><br>
Tanggal Order: <?= $order['created_at'] ?></p>

<h3>Data Pembeli</h3>
<p>Nama: <?= $order['name'] ?><br>
Email: <?= $order['email'] ?><br>
Telp: <?= $order['phone'] ?></p>

<h3>Data Pembayaran</h3>
<p>Metode: <?= $order['payment_method'] ?><br>
No Kartu: <?= $order['card_number'] ?><br>
Jumlah: <?= rupiah($order['payment_amount']) ?></p>

<p><strong>Bukti Pembayaran:</strong></p>
<?php if ($order['payment_proof']): ?>
<img src="<?= BASE_URL ?>/user/uploads/payments/<?= $order['payment_proof'] ?>" width="200">
<?php else: ?>
<p><em>Tidak ada bukti</em></p>
<?php endif; ?>
<?php
$html = ob_get_clean();
generatePDF($html, "payment_confirm_{$orderId}.pdf");