<?php
require_once '../includes/db.php';
require_once '../includes/functions.php';
require_once '../includes/user_auth.php';

$cart = $_SESSION['cart'] ?? [];
if (empty($cart)) die("Keranjang kosong");

$bankInfo = getSetting('bank_info', $pdo);
$qrisInfo = getSetting('qris_info', $pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $total = array_sum(array_map(fn($i) => $i['price'] * $i['qty'], $cart));

    // Insert order
    $pdo->beginTransaction();
    $stmt = $pdo->prepare("INSERT INTO orders (user_id, total_price, status) VALUES (?, ?, 'pending')");
    $stmt->execute([$_SESSION['user_id'], $total]);
    $orderId = $pdo->lastInsertId();

    $stmtItem = $pdo->prepare("INSERT INTO order_items (order_id, product_id, qty, price) VALUES (?, ?, ?, ?)");
    foreach ($cart as $pid => $item) {
        $stmtItem->execute([$orderId, $pid, $item['qty'], $item['price']]);
    }

    $pdo->commit();
    unset($_SESSION['cart']);

    header("Location: payment_confirm.php?order_id={$orderId}");
    exit;
}
?>
<html>
<head><title>Checkout - <?= SITE_NAME ?></title><link rel="stylesheet" href="../assets/css/style.css"></head>
<body>
<div class="container">
    <h2>Metode Pembayaran</h2>
    <p><?= nl2br($bankInfo) ?></p>
    <?php if ($qrisInfo): ?>
        <p>QRIS: <br><img src="<?= $qrisInfo ?>" width="200"></p>
    <?php endif; ?>
    <form method="POST">
        <button type="submit" class="btn btn-primary">Buat Pesanan</button>
    </form>
</div>
</body>
</html>
