<?php
$catId = isset($_GET['cat']) ? (int)$_GET['cat'] : 0;
if ($catId > 0) {
    $stmt = $pdo->prepare("SELECT * FROM products WHERE category_id=? OR category_id IN (SELECT category_id FROM categories WHERE parent_id=?) ORDER BY created_at DESC");
    $stmt->execute([$catId, $catId]);
} else {
    $stmt = $pdo->query("SELECT * FROM products ORDER BY created_at DESC");
}
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="layout-2col">
  <div class="sidebar">
    <h3>Kategori</h3>
    <?php getCategoryTree(null, $pdo); ?>
  </div>
  <div class="main">
    <h2 class="section-title">Daftar Produk</h2>
    <div class="products-grid">
      <?php foreach($products as $p): ?>
        <a href="index.php?page=product_detail&id=<?= $p['product_id'] ?>" class="product-card">
          <img src="<?= getProductImage($p['image']) ?>">
          <h3><?= htmlspecialchars($p['name']) ?></h3>
          <div class="price"><?= rupiah($p['price']) ?></div>
        </a>
      <?php endforeach; ?>
    </div>
  </div>
</div>
