<?php
require_once '../includes/db.php';

$msg = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = cleanInput($_POST['name']);
    $email = cleanInput($_POST['email']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $phone = cleanInput($_POST['phone']);
    $address = cleanInput($_POST['address']);

    $stmt = $pdo->prepare("INSERT INTO user_tbl (name, email, password, phone, address) VALUES (?, ?, ?, ?, ?)");
    try {
        $stmt->execute([$name, $email, $password, $phone, $address]);
        $msg = "Registrasi berhasil. <a href='login.php'>Login sekarang</a>";
    } catch (PDOException $e) {
        $msg = "Gagal registrasi: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Register - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Register</h2>
    <form method="POST">
        <input type="text" name="name" placeholder="Nama Lengkap" required>
        <input type="email" name="email" placeholder="Email" required>
        <input type="password" name="password" placeholder="Password" required>
        <input type="text" name="phone" placeholder="No. HP">
        <textarea name="address" placeholder="Alamat"></textarea>
        <button class="btn btn-primary" type="submit">Daftar</button>
    </form>
    <p><?= $msg ?></p>
</div>
</body>
</html>
