<?php
/**
 * API Class
 *
 * Handles communication with the Crawlconsole API
 */
require_once CRAWLCONSOLE_ANALYTICS_DIR . 'includes/class-constants.php';
class CrawlConsole_Analytics_API {
    public function send_analytics($analytics_data, $api_key) {
        // Only run on frontend, not in admin
        if (is_admin()) {
            return false;
        }

        $base_url = CrawlConsole_Analytics_Constants::BASE_URL;
        $track_endpoint = CrawlConsole_Analytics_Constants::TRACK_ENDPOINT;
        
        $endpoint = trailingslashit($base_url) . $track_endpoint;

        $args = array(
            'method'    => 'POST',
            'timeout'   => 5,
            'blocking'  => false,
            'headers'   => array(
                'Content-Type' => 'application/json',
                'x-api-key'    => $api_key,
            ),
            'body'      => json_encode($analytics_data),
            'cookies'   => array(),
        );

        $response = wp_remote_post($endpoint, $args);

        return true;
    }
}