<?php
$cartCount = isset($_SESSION['cart']) ? array_sum(array_column($_SESSION['cart'], 'qty')) : 0;
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title><?= isset($pageTitle) ? $pageTitle.' - ' : '' ?><?= SITE_NAME ?></title>
  <link rel="stylesheet" href="<?= BASE_URL ?>/assets/css/style.css">
</head>
<body>

<header>
  <div class="top-bar site-container">
    <a href="<?= BASE_URL ?>" class="font-bold"><?= SITE_NAME ?></a>
    <div>
      <a href="<?= BASE_URL ?>/user/index.php?page=cart">Cart (<?= $cartCount ?>)</a>
      <?php if (!empty($_SESSION['user_id'])): ?>
        <a href="index.php?page=dashboard">Dashboard</a>
        <a href="index.php?page=logout">Logout</a>
      <?php else: ?>
        <a href="index.php?page=login">Login</a>
      <?php endif; ?>
    </div>
  </div>
  <nav>
    <div class="site-container">
      <a href="<?= BASE_URL ?>">Home</a>
      <a href="index.php?page=products">Produk</a>
      <a href="index.php?page=articles">Artikel</a>
      <a href="index.php?page=contact">Kontak</a>
    </div>
  </nav>
</header>

<main class="site-container">
  <?php include $pageFile; ?>
</main>

<footer class="bg-gray-900 text-white mt-10">
  <div class="site-container">
    <p>&copy; <?= date('Y') ?> <?= SITE_NAME ?> - Semua Hak Dilindungi</p>
  </div>
  
  <script>
function toggleSubCat(el) {
    let subCat = el.parentElement.querySelector(".sub-cat");
    if (subCat.style.display === "none") {
        subCat.style.display = "block";
        el.textContent = "−";
    } else {
        subCat.style.display = "none";
        el.textContent = "+";
    }
}
</script>
</footer>

</body>
</html>
